//a simple example of how to update a single screen and use drawing functions
//for use with gamex.lib, created in Turbo C++
#include "stdlib.h"
#include "dos.h"
#include "grlib.h"

void main()
{
  int a,b,c;

  InitGameBuff(320,200);//make game buffer 1 screen big

  SetVGA();     //set VGA mode 13h

  randomize();

  //load in the pictures
  if (LoadPic1("back.pcx",0)==0) Quit("Pcx not found");

  //cover game buffer with backdrop image
  PutPic(0,0,0);

  //moving lines
  for(b=0; b<320; b+=2)
  {
    PutPic(0,0,0);

    Line(b,0,319-b,199,250);
    Line(319-b,0,b,199,250);

    DisplayBuffer(0,0);
  }

  //random dots
  for(a=0; a<300; a++)
  {
    PutPic(0,0,0);

    for(b=0; b<60; b++) PutPixel(random(320),random(200),255);

    DisplayBuffer(0,0);
  }


  //morphing rectangles
  b=50; c=50;

  for(a=0; a<400; a++)
  {
    PutPic(0,0,0);

    b=b+random(6)-random(6);
    c=c+random(6)-random(6);
    if (b>95) b=95; if (b<10) b=10;
    if (c>95) c=95; if (c<10) c=10;

    Rectangle(160-b,100-c,b*2,c*2,250,0);
    Rectangle(160-c,100-b,c*2,b*2,250,0);

    DisplayBuffer(0,0);
  }

  //plot alternate black lines down the screen directly,
  //without using the game buffer, and slowed with delays
  for(a=0; a<200; a+=2) {LineVGA(0,a,319,a,0); delay(15);}
  for(a=1; a<200; a+=2) {LineVGA(0,a,319,a,0); delay(15);}

  //close down
  FreeMem();
  SetTXT();
}
